import { GoogleGenerativeAI } from '@google/generative-ai';

const apiKey = process.env.GEMINI_API_KEY || '';
const genAI = new GoogleGenerativeAI(apiKey);

export function getGeminiModel(model = 'gemini-2.5-flash-lite') {
    return genAI.getGenerativeModel({ model });
}

export async function geminiPrompt(prompt: string): Promise<string> {
    if (!apiKey || apiKey === 'your_gemini_api_key_here') {
        throw new Error('GEMINI_API_KEY is not configured in your .env file.');
    }
    const model = getGeminiModel();
    const result = await model.generateContent(prompt);
    return result.response.text();
}
